import type { Schema, Struct } from '@strapi/strapi';

export interface CommonContactInfo extends Struct.ComponentSchema {
  collectionName: 'components_common_contact_infos';
  info: {
    displayName: 'Contact Info';
    icon: 'user';
  };
  attributes: {
    icon: Schema.Attribute.Component<'common.icon', true>;
    method: Schema.Attribute.Enumeration<
      ['Email', 'Whatsapp', 'Telegram', 'Phone', 'Address']
    > &
      Schema.Attribute.Required &
      Schema.Attribute.DefaultTo<'Phone'>;
    value: Schema.Attribute.String & Schema.Attribute.Required;
  };
}

export interface CommonFeatures extends Struct.ComponentSchema {
  collectionName: 'components_common_features';
  info: {
    displayName: 'Features';
    icon: 'bulletList';
  };
  attributes: {
    description: Schema.Attribute.Text;
    icon: Schema.Attribute.Component<'common.icon', true>;
    title: Schema.Attribute.String;
  };
}

export interface CommonIcon extends Struct.ComponentSchema {
  collectionName: 'components_common_icons';
  info: {
    displayName: 'Icon';
  };
  attributes: {
    icon_name: Schema.Attribute.Enumeration<
      [
        '    Code2',
        '    AppWindow',
        '    Palette',
        '    BriefcaseBusiness',
        '    BarChart3',
        '    Headset',
        '    Server',
        '    Brain',
        '    LifeBuoy',
        '    Wifi',
      ]
    >;
  };
}

export interface CommonSocialLinks extends Struct.ComponentSchema {
  collectionName: 'components_common_social_links';
  info: {
    displayName: 'Social Links';
    icon: 'earth';
  };
  attributes: {
    icon: Schema.Attribute.Component<'common.icon', true>;
    icon_image: Schema.Attribute.Media<'images' | 'files'>;
    platform: Schema.Attribute.Enumeration<
      [
        'Instagram',
        'Linkedin',
        'Telegram',
        'Github',
        'Dribble',
        'Behance',
        'TikTok',
        'Youtube',
        'X',
      ]
    >;
    url: Schema.Attribute.String & Schema.Attribute.Required;
  };
}

export interface SharedOpenGraph extends Struct.ComponentSchema {
  collectionName: 'components_shared_open_graphs';
  info: {
    displayName: 'openGraph';
    icon: 'project-diagram';
  };
  attributes: {
    ogDescription: Schema.Attribute.String &
      Schema.Attribute.Required &
      Schema.Attribute.SetMinMaxLength<{
        maxLength: 200;
      }>;
    ogImage: Schema.Attribute.Media<'images'>;
    ogTitle: Schema.Attribute.String &
      Schema.Attribute.Required &
      Schema.Attribute.SetMinMaxLength<{
        maxLength: 70;
      }>;
    ogType: Schema.Attribute.String;
    ogUrl: Schema.Attribute.String;
  };
}

export interface SharedSeo extends Struct.ComponentSchema {
  collectionName: 'components_shared_seos';
  info: {
    displayName: 'seo';
    icon: 'search';
  };
  attributes: {
    canonicalURL: Schema.Attribute.String;
    keywords: Schema.Attribute.Text;
    metaDescription: Schema.Attribute.String &
      Schema.Attribute.Required &
      Schema.Attribute.SetMinMaxLength<{
        maxLength: 160;
        minLength: 50;
      }>;
    metaImage: Schema.Attribute.Media<'images'>;
    metaRobots: Schema.Attribute.String;
    metaTitle: Schema.Attribute.String &
      Schema.Attribute.Required &
      Schema.Attribute.SetMinMaxLength<{
        maxLength: 60;
      }>;
    metaViewport: Schema.Attribute.String;
    openGraph: Schema.Attribute.Component<'shared.open-graph', false>;
    structuredData: Schema.Attribute.JSON;
  };
}

declare module '@strapi/strapi' {
  export module Public {
    export interface ComponentSchemas {
      'common.contact-info': CommonContactInfo;
      'common.features': CommonFeatures;
      'common.icon': CommonIcon;
      'common.social-links': CommonSocialLinks;
      'shared.open-graph': SharedOpenGraph;
      'shared.seo': SharedSeo;
    }
  }
}
