import type { Metadata } from "next";
import { Almarai, Poppins } from "next/font/google";
import "./globals.css";
import { ThemeProvider } from "@/core/components/theme-provider";
import { CustomCursor } from "@/components/ui/custom-cursor";
import { getLocale } from "next-intl/server";
import { getSettings } from "@/core/lib/api";
import { buildMetadataFromSeo } from "@/core/lib/seo";

const poppins = Poppins({
  variable: "--font-poppins",
  weight: ["400", "500", "600", "700"],
  subsets: ["latin"],
});

const almarai = Almarai({
  variable: "--font-almarai",
  weight: ["300", "400", "700", "800"],
  subsets: ["latin"],
});

export async function generateMetadata(): Promise<Metadata> {
  const settings = await getSettings();
  // Root layout is language-agnostic, default to English fallbacks
  return buildMetadataFromSeo({
    seo: (settings as any)?.seo ?? undefined,
    openGraph: (settings as any)?.openGraph ?? undefined,
    locale: "en",
  });
}

export default async function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  const locale = await getLocale();
  return (
    <html lang="en" className="dark" dir={locale === 'ar' ? 'rtl' : 'ltr'} suppressHydrationWarning>
      <body
        className={`${poppins.variable} ${almarai.variable} antialiased rtl:font-almarai font-poppins`}
      >
        <ThemeProvider
          attribute="class"
          defaultTheme="dark"
          enableSystem={false}
          disableTransitionOnChange
        >
          <CustomCursor />
          {/* <SmoothScroll> */}
          {children}
          {/* </SmoothScroll> */}
        </ThemeProvider>
      </body>
    </html>
  );
}
