/**
 * Strapi API types for apps/backend (Strapi v5)
 * Matches content-types in apps/backend/src/api
 */

// ============ Strapi media (v5) ============
export interface StrapiMedia {
  documentId: string;
  url: string;
  name?: string;
  alternativeText?: string | null;
  width?: number;
  height?: number;
  mime?: string;
  size?: number;
}

// ============ Pagination ============
export interface StrapiPagination {
  page: number;
  pageSize: number;
  pageCount: number;
  total: number;
}

export interface StrapiMeta {
  pagination?: StrapiPagination;
}

// ============ Shared SEO components ============
export interface StrapiOpenGraph {
  ogTitle?: string | null;
  ogDescription?: string | null;
  ogImage?: StrapiMedia | null;
  ogUrl?: string | null;
  ogType?: string | null;
}

export interface StrapiSeo {
  metaTitle?: string | null;
  metaDescription?: string | null;
  metaImage?: StrapiMedia | null;
  openGraph?: StrapiOpenGraph | null;
  keywords?: string | null;
  metaRobots?: string | null;
  metaViewport?: string | null;
  canonicalURL?: string | null;
  structuredData?: unknown;
}

// ============ Project (api::project.project) ============
export interface StrapiProject {
  documentId: string;
  title: string;
  slug: string;
  cover_image: StrapiMedia;
  live_url?: string | null;
  overview?: string | StrapiBlockNode[] | null; // richtext (markdown) or blocks (legacy)
  gallery?: StrapiMedia[] | null;
  categories?: StrapiCategory[] | null;
  service?: StrapiService | null;
  technologies?: StrapiTechnology[] | null;
  seo?: StrapiSeo | null;
  openGraph?: StrapiOpenGraph | null;
  publishedAt?: string | null;
  createdAt?: string;
  updatedAt?: string;
}

// ============ Category (api::category.category) ============
export interface StrapiCategory {
  documentId: string;
  name?: string;
  slug?: string;
  description?: string | null;
}

// ============ Technology (api::technology.technology) ============
export interface StrapiTechnology {
  documentId: string;
  title?: string;
  slug?: string;
  ref?: string | null;
  logo?: StrapiMedia | null;
}

// ============ Service (api::service.service) ============
export interface StrapiFeature {
  documentId?: string;
  title?: string;
  description?: string | null;
  icon?: unknown;
}

export interface StrapiService {
  documentId: string;
  name: string;
  slug: string;
  image?: StrapiMedia | null;
  short_description?: string | null;
  full_description?: string | null;
  LucidIcon?: unknown;
  features?: StrapiFeature[] | null;
   // SEO
  seo?: StrapiSeo | null;
  openGraph?: StrapiOpenGraph | null;
  publishedAt?: string | null;
}

// ============ Partner (api::partner.partner) ============
export interface StrapiPartner {
  documentId: string;
  name?: string;
  logo?: StrapiMedia | null;
  publishedAt?: string | null;
}

// ============ Setting - contact_info component ============
export interface StrapiContactInfo {
  documentId?: string;
  method: "Email" | "Whatsapp" | "Telegram" | "Phone" | "Address";
  value: string;
  icon?: unknown;
}

export interface StrapiSocialLink {
  documentId?: string;
  platform?: string;
  url?: string;
}

// ============ Setting (single type) ============
export interface StrapiSetting {
  documentId: string;
  footer_text?: string | null;
  social_links?: StrapiSocialLink[] | null;
  contact_info?: StrapiContactInfo[] | null;
  logo?: StrapiMedia | null;
  seo?: StrapiSeo | null;
  openGraph?: StrapiOpenGraph | null;
  publishedAt?: string | null;
}

// ============ Tag (api::tag.tag) ============
export interface StrapiTag {
  documentId: string;
  title?: string;
  slug?: string;
  publishedAt?: string | null;
}

// ============ Blog (api::blog.blog) ============
export interface StrapiBlog {
  documentId: string;
  title: string;
  slug: string;
  content?: string | StrapiBlockNode[] | null; // richtext (markdown) or blocks
  cover: StrapiMedia;
  author?: StrapiAuthor | null;
  tags?: StrapiTag[] | null;
  category?: StrapiCategory | null;
  seo?: StrapiSeo | null;
  openGraph?: StrapiOpenGraph | null;
  publishedAt?: string | null;
  createdAt?: string;
  updatedAt?: string;
}

/** Simplified user from Strapi users-permissions */
export interface StrapiAuthor {
  documentId?: string;
  username?: string;
  email?: string;
}

// ============ Strapi Blocks (rich text) ============
export type StrapiBlockNode =
  | StrapiParagraphBlock
  | StrapiHeadingBlock
  | StrapiListBlock
  | StrapiImageBlock
  | StrapiQuoteBlock
  | StrapiCodeBlock;

export interface StrapiTextChild {
  type: "text";
  text: string;
  bold?: boolean;
  italic?: boolean;
  underline?: boolean;
  strikethrough?: boolean;
  code?: boolean;
}

export interface StrapiLinkChild {
  type: "link";
  url: string;
  children: StrapiTextChild[];
}

export type StrapiInlineNode = StrapiTextChild | StrapiLinkChild;

export interface StrapiParagraphBlock {
  type: "paragraph";
  children: StrapiInlineNode[];
}

export interface StrapiHeadingBlock {
  type: "heading";
  level: 1 | 2 | 3 | 4 | 5 | 6;
  children: StrapiInlineNode[];
}

export interface StrapiListBlock {
  type: "list";
  format: "ordered" | "unordered";
  children: { type: "list-item"; children: StrapiInlineNode[] }[];
}

export interface StrapiImageBlock {
  type: "image";
  image: StrapiMedia;
  children: StrapiTextChild[];
}

export interface StrapiQuoteBlock {
  type: "quote";
  children: StrapiInlineNode[];
}

export interface StrapiCodeBlock {
  type: "code";
  children: StrapiTextChild[];
}

// ============ Home (single type) - optional for curated lists ============
export interface StrapiHome {
  documentId: string;
  hero_text?: string | null;
  projects?: StrapiProject[] | null;
  services?: StrapiService[] | null;
  testimonials?: unknown[] | null;
  seo?: StrapiSeo | null;
  openGraph?: StrapiOpenGraph | null;
  publishedAt?: string | null;
}

// ============ API response wrappers ============
export interface StrapiCollectionResponse<T> {
  data: T[];
  meta: StrapiMeta;
}

export interface StrapiSingleResponse<T> {
  data: T | null;
  meta?: StrapiMeta;
}
