"use client";

import { motion } from "motion/react";
import { BookOpen } from "lucide-react";

interface BlogHeaderProps {
  title?: string;
  subtitle?: string;
}

export function BlogHeader({
  title = "Blog",
  subtitle = "Insights, tutorials, and updates from our team",
}: BlogHeaderProps) {
  return (
    <div className="relative overflow-hidden border-b border-slate-800/50 bg-slate-950 pt-32 pb-16 md:pt-40 md:pb-20">
      {/* Background effects */}
      <div className="absolute inset-0 pointer-events-none">
        <div className="absolute top-0 left-1/2 -translate-x-1/2 h-96 w-200 bg-cyan-600/5 rounded-full blur-[150px]" />
        <div className="absolute bottom-0 right-0 h-64 w-64 bg-blue-600/10 rounded-full blur-[100px]" />
      </div>

      {/* Grid pattern */}
      <div
        className="absolute inset-0 opacity-[0.03]"
        style={{
          backgroundImage: `linear-gradient(rgba(255,255,255,0.1) 1px, transparent 1px),
                           linear-gradient(90deg, rgba(255,255,255,0.1) 1px, transparent 1px)`,
          backgroundSize: "64px 64px",
        }}
      />

      <div className="container relative z-10">
        <motion.div
          className="mx-auto max-w-3xl text-center"
          initial={{ opacity: 0, y: 30, filter: "blur(15px)" }}
          animate={{ opacity: 1, y: 0, filter: "blur(0px)" }}
          transition={{ duration: 0.8, ease: [0.22, 1, 0.36, 1] }}
        >
          {/* Icon badge */}
          <motion.div
            className="mb-6 inline-flex items-center gap-2 rounded-full border border-cyan-500/20 bg-cyan-500/10 px-4 py-2 text-sm text-cyan-400"
            initial={{ opacity: 0, scale: 0.8 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ delay: 0.2, duration: 0.5 }}
          >
            <BookOpen className="h-4 w-4" />
            <span>Our Blog</span>
          </motion.div>

          <motion.h1
            className="text-4xl font-bold tracking-tight text-white md:text-5xl lg:text-6xl"
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.1, duration: 0.6 }}
          >
            {title}
          </motion.h1>

          <motion.p
            className="mt-4 text-lg text-slate-400 md:text-xl"
            initial={{ opacity: 0, y: 15 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.2, duration: 0.6 }}
          >
            {subtitle}
          </motion.p>
        </motion.div>
      </div>
    </div>
  );
}
