import { getTranslations } from "next-intl/server";

export async function TechExpertise() {
  const t = await getTranslations("techExpertise");

  return (
    <section id="tech-expertise" className="container py-24 md:py-32">
      <div className="mx-auto flex max-w-[980px] flex-col items-center gap-4 text-center">
        <h2 className="text-3xl font-bold">{t("title")}</h2>
        <p className="text-muted-foreground">{t("subtitle")}</p>
        <p className="mt-4 text-muted-foreground">{t("placeholder")}</p>
      </div>
    </section>
  );
}
