import type { NextConfig } from "next";
import createNextIntlPlugin from "next-intl/plugin";

const withNextIntl = createNextIntlPlugin("./core/lib/i18n/request.ts");

const nextConfig: NextConfig = {
  images: {
    remotePatterns: [
      { protocol: "https", hostname: "images.unsplash.com" },
      { protocol: "http", hostname: "localhost", port: "1337", pathname: "/uploads/**" },
      { protocol: "https", hostname: "*.strapiapp.com", pathname: "/uploads/**" },
      { protocol: "https", hostname: "refreshing-melody-6e42cb4ccd.media.strapiapp.com" },
    ],
  },
};

export default withNextIntl(nextConfig);
