import {
    Code2,
    AppWindow,
    Palette,
    BriefcaseBusiness,
    BarChart3,
    Headset,
    Server,
    Brain,
    LifeBuoy,
    Wifi,
} from "lucide-react";
import type { LucideIcon } from "lucide-react";
import { cn } from "@/core/lib/utils";

const Icons = {
    Code2,
    AppWindow,
    Palette,
    BriefcaseBusiness,
    BarChart3,
    Headset,
    Server,
    Brain,
    LifeBuoy,
    Wifi,
} satisfies Record<string, LucideIcon>;

type DynamicIconProps = {
    icon: keyof typeof Icons | string;
    className?: string;
};

export const DynamicIcon = ({ icon, className }: DynamicIconProps) => {
    const Icon =
        Icons[icon as keyof typeof Icons] ??
        // Fallback if icon name is invalid
        Code2;

    return <Icon className={cn("h-5 w-5", className)} />;
};